@name "place of worship";

@meta {
	classifyFacades: 0;
}

footprint {
	height: attr("height") | 8.;
	minHeight: attr("min_height");
	numLevels: 0;
	topHeight: 0.;
	roofShape: attr("roof:shape") | flat;
	roofHeight: attr("roof:height");
	roofOrientation: attr("roof:orientation");
	claddingMaterial:
		attr("building:material") | bldgAttr("building:material") | plaster
	;
	claddingColor:
		attr("building:colour")
		|
		bldgAttr("building:colour")
		|
		// plaster
		per_building(random_weighted(
			(#ffffff, 1),
            (#aaaaaa, 1),
            (#bbbbbb, 1),
			(#cccccc, 1),
			(#dddddd, 1),
			(#eeeeee, 1)
		))
	;
}

facade {
// cladding material only
}

roof {
	roofCladdingMaterial: attr("roof:material") | bldgAttr("roof:material") | metal;
	roofCladdingColor:
		attr("roof:colour")
		|
		bldgAttr("roof:colour")
		|
		// roofCladdingMaterial == "metal"
		per_building(random_weighted(
            (#ffffff, 1),
            (#aaaaaa, 1),
            (#bbbbbb, 1)
		))
	;
	faces: if (item.footprint["roofShape"] in ("dome", "onion")) smooth;
}